/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.datasource.db.types;

import de.willuhn.datasource.db.types.TypeGeneric;
import de.willuhn.logging.Logger;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class TypeByteArray
extends TypeGeneric {
    @Override
    public Object get(ResultSet rs, String name) throws SQLException {
        Object value = super.get(rs, name);
        if (value == null) {
            return null;
        }
        InputStream is = null;
        if (value instanceof InputStream) {
            is = (InputStream)value;
        } else if (value instanceof Blob) {
            Blob b = (Blob)value;
            is = b.getBinaryStream();
        } else if (value instanceof byte[]) {
            return value;
        }
        if (is == null) {
            Logger.warn((String)("don't know how to handle type " + value.getClass().getName() + " - returning unchanged"));
            return value;
        }
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            byte[] buf = new byte[1024];
            int len = 0;
            while ((len = is.read(buf)) != -1) {
                bos.write(buf, 0, len);
            }
            byte[] byArray = bos.toByteArray();
            return byArray;
        }
        catch (IOException ioe) {
            throw new SQLException("unable to read blob: " + ioe.getMessage());
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e) {
                throw new SQLException("unable to close inputstream: " + e.getMessage());
            }
        }
    }

    @Override
    public void set(PreparedStatement stmt, int index, Object value) throws SQLException {
        if (value == null) {
            stmt.setNull(index, 0);
        } else {
            stmt.setBytes(index, (byte[])value);
        }
    }
}

